<?php
require 'db.php';

$token = $_GET['token'] ?? '';
if (!$token) { echo "Invalid token"; exit; }

$stmt = $pdo->prepare("SELECT id, petition_id, is_verified FROM signatures WHERE verify_token = ? LIMIT 1");
$stmt->execute([$token]);
$sig = $stmt->fetch();
if (!$sig) { echo "Invalid or expired token"; exit; }
if ($sig['is_verified']) { echo "Already verified"; exit; }

$pdo->prepare("UPDATE signatures SET is_verified = 1, verified_at = NOW(), verify_token = NULL WHERE id = ?")->execute([$sig['id']]);

// Redirect to petition with success message
header("Location: /petition.php?id={$sig['petition_id']}&verified=1");
exit;
