<?php
require 'db.php';
header('Content-Type: application/json');

$post = json_decode(file_get_contents('php://input'), true);
$petition_id = intval($post['petition_id'] ?? 0);
$name = trim($post['name'] ?? '');
$email = filter_var($post['email'] ?? '', FILTER_VALIDATE_EMAIL);
$comment = trim($post['comment'] ?? '');

if (!$petition_id || !$name || !$email) {
  http_response_code(400);
  echo json_encode(['error' => 'Missing fields']);
  exit;
}

// rate-limit: check last submission from same IP or email in last X seconds (simple example)
$ip = $_SERVER['REMOTE_ADDR'];
$stmt = $pdo->prepare("SELECT COUNT(*) as cnt FROM signatures WHERE petition_id = ? AND (ip_address = ? OR email = ?) AND created_at > (NOW() - INTERVAL 30 SECOND)");
$stmt->execute([$petition_id, $ip, $email]);
if ($stmt->fetchColumn() > 0) {
  http_response_code(429);
  echo json_encode(['error' => 'Too many attempts, please wait']);
  exit;
}

$token = bin2hex(random_bytes(24));
$stmt = $pdo->prepare("INSERT INTO signatures (petition_id, name, email, comment, is_verified, verify_token, ip_address, user_agent) VALUES (?, ?, ?, ?, 0, ?, ?, ?)");
$stmt->execute([$petition_id, $name, $email, $comment, $token, $ip, $_SERVER['HTTP_USER_AGENT'] ?? '']);

$signature_id = $pdo->lastInsertId();

// TODO: queue an email with verification link
$verify_link = "https://wewant.com.au/verify_signature.php?token={$token}";

// For demo, we output the verify link. In production, email the link and don't expose it.
echo json_encode(['success' => true, 'signature_id' => $signature_id, 'verify_link' => $verify_link]);
