<?php
require 'db.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
if (!$data || empty($data['title']) || empty($data['description'])) {
  http_response_code(400);
  echo json_encode(['error' => 'Missing required fields']);
  exit;
}

$slug = preg_replace('/[^a-z0-9\-]/','', strtolower(substr($data['title'],0,60)));
$slug .= '-' . bin2hex(random_bytes(3));

// Basic insert (user_id optional)
$stmt = $pdo->prepare("INSERT INTO petitions (user_id, slug, title, description, goal, image_url, category, target, is_published) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->execute([
  $data['user_id'] ?? null,
  $slug,
  $data['title'],
  $data['description'],
  intval($data['goal'] ?? 1000),
  $data['image_url'] ?? null,
  $data['category'] ?? null,
  $data['target'] ?? null,
  intval($data['is_published'] ?? 0)
]);

$petitionId = $pdo->lastInsertId();

echo json_encode(['success' => true, 'petition_id' => $petitionId, 'slug' => $slug]);
